<?php
// test_api.php
echo "<h2>Testing API Connection to get_user.php</h2>";

$api_url = 'https://ams.onesbd.com/get_user.php';

// Test with different approaches
echo "<h3>Method 1: file_get_contents</h3>";
try {
    $response = file_get_contents($api_url);
    if ($response !== false) {
        echo "✅ file_get_contents SUCCESS<br>";
        echo "Response length: " . strlen($response) . " characters<br>";
        echo "First 500 chars: <pre>" . htmlspecialchars(substr($response, 0, 500)) . "</pre>";
    } else {
        echo "❌ file_get_contents failed<br>";
    }
} catch (Exception $e) {
    echo "❌ file_get_contents error: " . $e->getMessage() . "<br>";
}

echo "<h3>Method 2: cURL</h3>";
$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $api_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_USERAGENT => 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36'
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);

echo "HTTP Code: $http_code<br>";
echo "cURL Error: " . ($error ? $error : 'None') . "<br>";

if ($http_code === 200 && $response) {
    echo "✅ cURL SUCCESS<br>";
    echo "Response length: " . strlen($response) . " characters<br>";
    
    // Check if it's JSON
    $json_data = json_decode($response, true);
    if (json_last_error() === JSON_ERROR_NONE) {
        echo "✅ Valid JSON format<br>";
        echo "Data type: " . gettype($json_data) . "<br>";
        if (is_array($json_data)) {
            echo "Array count: " . count($json_data) . "<br>";
            echo "Sample data: <pre>" . print_r(array_slice($json_data, 0, 3), true) . "</pre>";
        }
    } else {
        echo "⚠️ Not JSON: " . htmlspecialchars(substr($response, 0, 200)) . "<br>";
    }
} else {
    echo "❌ cURL failed<br>";
}

curl_close($ch);
?>