<?php
// save_att.php
// Place in public_html/api/save_att.php
// Protect with a strong token. Use HTTPS when calling this API.

header('Content-Type: application/json; charset=utf-8');

// === CONFIG ===
$API_TOKEN = 'REPLACE_WITH_A_STRONG_TOKEN_!DoNotShare!';  // <<-- set your token here
$dbHost = 'localhost';
$dbUser = 'onesqeif_799';
$dbPass = '!QJ{xhY5Dkz1';
$dbName = 'student_attendence';
// =================

// Basic token auth (Bearer)
$headers = getallheaders();
$authOK = false;
if (isset($headers['Authorization'])) {
    $auth = trim($headers['Authorization']);
    if (stripos($auth, 'Bearer ') === 0) {
        $token = trim(substr($auth, 7));
        if ($token === $API_TOKEN) $authOK = true;
    }
}
// Some PHP installs return HTTP_AUTHORIZATION instead
if (!$authOK && isset($_SERVER['HTTP_AUTHORIZATION'])) {
    $auth = trim($_SERVER['HTTP_AUTHORIZATION']);
    if (stripos($auth, 'Bearer ') === 0) {
        $token = trim(substr($auth, 7));
        if ($token === $API_TOKEN) $authOK = true;
    }
}
if (!$authOK) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Read JSON body
$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if (!is_array($data)) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON']);
    exit;
}

// Connect to DB
$mysqli = new mysqli($dbHost, $dbUser, $dbPass, $dbName);
if ($mysqli->connect_errno) {
    http_response_code(500);
    echo json_encode(['error' => 'DB connect failed', 'msg' => $mysqli->connect_error]);
    exit;
}
$mysqli->set_charset('utf8mb4');

// helper: compute status
function compute_status($datetime_str) {
    // expects 'YYYY-MM-DD HH:MM:SS' or ISO formats parseable by strtotime
    $ts = strtotime($datetime_str);
    if ($ts === false) return 'A';
    $t = (int)date('Hi', $ts); // e.g. 0845 -> 845
    // P: 08:30 - 09:00  => 0830 - 0900
    if ($t >= 830 && $t <= 900) return 'P';
    // L: 09:01 - 09:15 => 0901 - 0915
    if ($t >= 901 && $t <= 915) return 'L';
    // HD: 09:16 - 10:00 => 0916 - 1000
    if ($t >= 916 && $t <= 1000) return 'HD';
    // else A
    return 'A';
}

// prepare statements
$stmtFindStudent = $mysqli->prepare("SELECT id FROM students WHERE device_user_id = ? LIMIT 1");
$stmtCheckDup = $mysqli->prepare("SELECT id FROM attendance WHERE student_id = ? AND scan_time = ? LIMIT 1");
$stmtInsert = $mysqli->prepare("INSERT INTO attendance (student_id, scan_time, status) VALUES (?, ?, ?)");

$inserted = 0;
$skipped = 0;
$missings = [];

// Accept either array of records or single record object
$records = $data;
if (isset($data['device_id']) && isset($data['scan_time'])) {
    // single record posted as object
    $records = [$data];
}

foreach ($records as $rec) {
    // expected keys: device_id (or user_id), scan_time (YYYY-MM-DD HH:MM:SS)
    $device_id = null;
    if (isset($rec['device_id'])) $device_id = intval($rec['device_id']);
    elseif (isset($rec['user_id'])) $device_id = intval($rec['user_id']);
    if (!$device_id) {
        $skipped++;
        continue;
    }

    $scan_time_raw = isset($rec['scan_time']) ? $rec['scan_time'] : (isset($rec['timestamp']) ? $rec['timestamp'] : null);
    if (!$scan_time_raw) {
        $skipped++;
        continue;
    }
    // normalize to MySQL DATETIME
    $ts = strtotime($scan_time_raw);
    if ($ts === false) {
        $skipped++;
        continue;
    }
    $scan_time = date('Y-m-d H:i:s', $ts);
    $status = compute_status($scan_time);

    // find student
    $stmtFindStudent->bind_param('i', $device_id);
    $stmtFindStudent->execute();
    $res = $stmtFindStudent->get_result();
    if (!$res || $res->num_rows == 0) {
        $missings[] = $device_id;
        $skipped++;
        continue;
    }
    $row = $res->fetch_assoc();
    $student_id = intval($row['id']);

    // check duplicate
    $stmtCheckDup->bind_param('is', $student_id, $scan_time);
    $stmtCheckDup->execute();
    $res2 = $stmtCheckDup->get_result();
    if ($res2 && $res2->num_rows > 0) {
        $skipped++;
        continue;
    }

    // insert
    $stmtInsert->bind_param('iss', $student_id, $scan_time, $status);
    if ($stmtInsert->execute()) {
        $inserted++;
    } else {
        // log but continue
        error_log('Insert failed: '.$mysqli->error);
        $skipped++;
    }
}

// close
$stmtFindStudent->close();
$stmtCheckDup->close();
$stmtInsert->close();
$mysqli->close();

echo json_encode([
    'ok' => true,
    'inserted' => $inserted,
    'skipped' => $skipped,
    'missing_device_user_ids' => array_values(array_unique($missings))
], JSON_UNESCAPED_UNICODE);
?>
